/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth.filter;

import de.narimo.commons.ws.http.CookieTools;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.geocore.ws.auth.tools.AuthenticationTools;
import java.io.IOException;
import javax.annotation.Priority;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=5000)
public class GeorepoSessionHandler
implements ContainerResponseFilter {
    @Context
    ServletContext ctxt;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        System.out.println(this.getClass().getSimpleName());
        System.out.println("Stateless request: " + requestContext.getProperty("stateless"));
        if (requestContext.getProperty("stateless") != null && ((Boolean)requestContext.getProperty("stateless")).booleanValue()) {
            System.out.println("Terminating session context for stateless request.");
            try {
                Cookie[] cs = ((HTTPAuthorizationFactory)requestContext.getProperty("authFactory")).getSessionCookies();
                Cookie sessionCookie = CookieTools.getCookie((Cookie[])cs, (String)"GSESSIONID");
                if (sessionCookie != null) {
                    String sessionid = sessionCookie.getValue();
                    AuthenticationTools.destroySession(sessionid, false);
                }
            }
            catch (Exception e) {
                System.out.println("Logout error. Probably session has not been removed correctly.");
                e.printStackTrace();
            }
        }
    }
}

