/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth.filter;

import de.narimo.commons.UserCredentials;
import de.narimo.geocore.ws.auth.ApiKeyAuth;
import de.narimo.geocore.ws.auth.filter.BearerAuthenticationFilter;
import de.narimo.geocore.ws.auth.tools.AuthenticationFilterTools;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;

public abstract class ApiKeyAuthenticationFilter
extends BearerAuthenticationFilter {
    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        System.out.println(this.getClass().getSimpleName());
        try {
            this.filterApiKey(requestContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            ApiKeyAuthenticationFilter.refuseRequest403(requestContext);
        }
    }

    void filterApiKey(ContainerRequestContext requestContext) throws Exception {
        String allowApiKeyAuth = this.ctx.getInitParameter("ALLOW_APIKEY_AUTH");
        if (allowApiKeyAuth == null || !allowApiKeyAuth.equals("true")) {
            this.filterBearer(requestContext);
            return;
        }
        System.out.println("Checking apikey auth...");
        String apiKey = AuthenticationFilterTools.getApiKey(requestContext.getUriInfo());
        if (apiKey == null) {
            this.filterBearer(requestContext);
            return;
        }
        UserCredentials credentials = ApiKeyAuth.authenticateApiKey(requestContext, apiKey);
        if (!this.checkCredentials(requestContext, credentials)) {
            return;
        }
        System.out.println("ApiKeyAuthFilter, authentication successful for " + credentials.getUsername() + ".");
        this.prepareSecurityContext(requestContext, credentials);
    }

    public UserCredentials authenticateApiKey(ContainerRequestContext requestContext, String apiKey) throws Exception {
        throw new UnsupportedOperationException("Invalid authentication filter base class. Use a custom filter implementation.");
    }
}

