/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.repository;

import de.narimo.commons.dto.geometa.User;
import de.narimo.commons.jdbc.JDBCConnectionJNDI;
import de.narimo.geocore.ws.registration.RegistrationLanguage;
import de.narimo.geocore.ws.registration.UserRegistrationDetails;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;

public class UserRepository {
    public static Integer getUserId(String username) {
        JDBCConnectionJNDI jdbc = null;
        try {
            jdbc = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            Integer userid = null;
            ResultSet rs = null;
            String idSql = "SELECT id FROM users WHERE username ILIKE ? AND enabled=true;";
            System.out.println(idSql);
            PreparedStatement ps = jdbc.prepareStatement(idSql);
            ps.setString(1, username);
            rs = ps.executeQuery();
            if (rs.next()) {
                userid = rs.getInt(1);
            }
            Integer n = userid;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not get userid for user " + username + ".");
        }
        finally {
            if (jdbc != null) {
                jdbc.closeAll();
                jdbc = null;
            }
        }
    }

    public static Optional<User> getUser(String username) {
        JDBCConnectionJNDI jdbc = null;
        try {
            jdbc = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            String idSql = "SELECT id, username, email FROM users WHERE username ILIKE ? AND enabled=true;";
            PreparedStatement ps = jdbc.prepareStatement(idSql);
            ps.setString(1, username);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                User user = new User();
                user.setId(Integer.valueOf(rs.getInt("id")));
                user.setEmail(rs.getString("email"));
                user.setName(rs.getString("username"));
                Optional<User> optional = Optional.ofNullable(user);
                return optional;
            }
            Optional<User> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not get user for username " + username + ".");
        }
        finally {
            if (jdbc != null) {
                jdbc.closeAll();
                jdbc = null;
            }
        }
    }

    public static String createUser(UserRegistrationDetails registrationDetails) throws IOException {
        JDBCConnectionJNDI jdbc = null;
        try {
            jdbc = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            String idSql = "INSERT INTO users (organisation, password, username, name, surname, email, regsecret, allowedworkspacecount, language) VALUES(?, sha256g(?), ?, ?, ?, ?, ?, ?, ?)";
            System.out.println(idSql);
            String registrationSecret = UserRepository.createAlphanumericSecret();
            PreparedStatement ps = jdbc.prepareStatement(idSql);
            ps.setString(1, registrationDetails.getOrganisation());
            ps.setString(2, registrationDetails.getPassword());
            ps.setString(3, registrationDetails.getEmail());
            ps.setString(4, registrationDetails.getFirstName());
            ps.setString(5, registrationDetails.getLastName());
            ps.setString(6, registrationDetails.getEmail());
            ps.setString(7, registrationSecret);
            ps.setInt(8, 1);
            ps.setString(9, RegistrationLanguage.getRegistrationLanguage(registrationDetails.getLanguage()));
            ps.execute();
            String string = registrationSecret;
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (e.getMessage().contains("duplicate key value violates unique constraint")) {
                throw new IOException("Username or email is already registered: " + registrationDetails.getEmail() + ".");
            }
            if (e.getMessage().contains("null value in column")) {
                throw new IOException("Registration details not complete.");
            }
            throw new InternalError(e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Could not create user " + registrationDetails.getEmail() + ".");
        }
        finally {
            if (jdbc != null) {
                jdbc.closeAll();
            }
            jdbc = null;
        }
    }

    public static List<User> getUsersById(List<Integer> userIds) {
        JDBCConnectionJNDI jdbcMeta = null;
        ArrayList<User> users = new ArrayList<User>();
        if (userIds == null || userIds.isEmpty()) {
            return users;
        }
        try {
            jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            String sql = "SELECT id, email FROM users WHERE id IN (?) AND enabled=true;";
            String sqlIN = userIds.stream().map(x -> String.valueOf(x)).collect(Collectors.joining(",", "(", ")"));
            sql = sql.replace("(?)", sqlIN);
            PreparedStatement ps0 = jdbcMeta.prepareStatement(sql);
            ResultSet rs = ps0.executeQuery();
            while (rs.next()) {
                User user = new User();
                user.setId(Integer.valueOf(rs.getInt("id")));
                user.setEmail(rs.getString("email"));
                users.add(user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError();
        }
        finally {
            if (jdbcMeta != null) {
                jdbcMeta.closeAll();
                jdbcMeta = null;
            }
        }
        return users;
    }

    public static void confirmUserRegistration(String email, String registrationSecret) throws IOException {
        JDBCConnectionJNDI jdbc = null;
        try {
            jdbc = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            String sql = "SELECT count(*) FROM users WHERE email ILIKE ? and regsecret=?;";
            PreparedStatement ps0 = jdbc.prepareStatement(sql);
            ps0.setString(1, email);
            ps0.setString(2, registrationSecret);
            ResultSet rs = ps0.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            if (count != 1) {
                throw new IOException("Invalid registration details.");
            }
            String sql1 = "UPDATE users SET enabled=true, regsecret=null, confirmedat=now() WHERE email ILIKE ? and regsecret=?;";
            System.out.println(sql1);
            PreparedStatement ps = jdbc.prepareStatement(sql1);
            ps.setString(1, email);
            ps.setString(2, registrationSecret);
            ps.executeUpdate();
            ResultSet rs2 = ps0.executeQuery();
            int ccount = 0;
            if (rs2.next()) {
                ccount = rs2.getInt(1);
            }
            if (ccount != 0) {
                System.out.println("ccount is " + ccount + ".");
                throw new IOException("Confirmation could not be completed successfully.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new InternalError(e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Could not confirm user registration" + email + ".");
        }
        finally {
            if (jdbc != null) {
                jdbc.closeAll();
                jdbc = null;
            }
        }
    }

    public static String setPasswordResetSecret(int userid) throws IOException {
        JDBCConnectionJNDI jdbc = null;
        try {
            jdbc = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            String secret = UserRepository.createAlphanumericSecret();
            String sql = "UPDATE users SET pwresetsecret=? WHERE id=?;";
            PreparedStatement ps0 = jdbc.prepareStatement(sql);
            ps0.setString(1, secret);
            ps0.setInt(2, userid);
            int count = ps0.executeUpdate();
            if (count != 1) {
                throw new InternalError("Setting password reset secret failed.");
            }
            String string = secret;
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new InternalError(e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Setting password reset secret failed..");
        }
        finally {
            if (jdbc != null) {
                jdbc.closeAll();
                jdbc = null;
            }
        }
    }

    public static void resetPassword(String newPassword, String passwordResetSecret, String email) throws IOException {
        JDBCConnectionJNDI jdbc = null;
        try {
            jdbc = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            String sql = "SELECT count(*) FROM users WHERE pwresetsecret=? and email ILIKE ?;";
            PreparedStatement ps0 = jdbc.prepareStatement(sql);
            ps0.setString(1, passwordResetSecret);
            ps0.setString(2, email);
            ResultSet rs = ps0.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            if (count != 1) {
                System.out.println("Reset password failed. There is no entry that matches mail " + email + " and secret " + passwordResetSecret + ".");
                throw new InternalError("Reset password failed.");
            }
            String sql1 = "UPDATE users SET password=sha256g(?), pwresetsecret=? WHERE pwresetsecret=? and email ILIKE ?;";
            PreparedStatement ps1 = jdbc.prepareStatement(sql1);
            ps1.setString(1, newPassword);
            ps1.setString(2, null);
            ps1.setString(3, passwordResetSecret);
            ps1.setString(4, email);
            count = ps1.executeUpdate();
            if (count != 1) {
                System.out.println("Updated row count: " + count + ". Should be 1.");
                throw new InternalError("Reset password failed.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new InternalError(e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Reset password failed.");
        }
        finally {
            if (jdbc != null) {
                jdbc.closeAll();
                jdbc = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canUserCreateWorkspace(long userId) {
        JDBCConnectionJNDI jdbc = null;
        JDBCConnectionJNDI jdbcMeta = null;
        try {
            jdbc = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            jdbcMeta = new JDBCConnectionJNDI("jdbc/georepoMetaResource");
            String idSql = "SELECT allowedworkspacecount FROM users WHERE id=? AND enabled=true;";
            System.out.println(idSql);
            PreparedStatement ps = jdbc.prepareStatement(idSql);
            ps.setLong(1, userId);
            ResultSet rs = ps.executeQuery();
            int allowedWorkspaceCount = 0;
            if (rs.next()) {
                allowedWorkspaceCount = rs.getInt("allowedworkspacecount");
            }
            String sql = "SELECT count(*) FROM workspaces WHERE userid=?;";
            System.out.println(sql);
            PreparedStatement ps1 = jdbcMeta.prepareStatement(sql);
            ps1.setLong(1, userId);
            ResultSet rs1 = ps1.executeQuery();
            if (rs1.next()) {
                Integer existingWorkspaces = rs1.getInt(1);
                boolean bl = allowedWorkspaceCount - existingWorkspaces > 0;
                return bl;
            }
        }
        catch (Exception e) {
            System.out.println("Could not determine workspace creation permissions for user " + userId + ".");
            e.printStackTrace();
        }
        finally {
            if (jdbc != null) {
                jdbc.closeAll();
                jdbc = null;
            }
            if (jdbcMeta != null) {
                jdbcMeta.closeAll();
                jdbcMeta = null;
            }
        }
        return false;
    }

    public static void disableUser(int userid) throws IOException {
        JDBCConnectionJNDI jdbc = null;
        try {
            jdbc = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            String removedUsername = "removed" + Math.round(Math.random() * 10000.0);
            String sql = "UPDATE users SET enabled=false, username=?, email=null, disabledat=now() WHERE id=?;";
            PreparedStatement ps0 = jdbc.prepareStatement(sql);
            ps0.setString(1, removedUsername);
            ps0.setInt(2, userid);
            ps0.executeUpdate();
        }
        catch (Exception e) {
            System.out.println("Updating user failed.");
            e.printStackTrace();
            throw new InternalError("User account should have been deleted but might have failed!");
        }
        finally {
            if (jdbc != null) {
                jdbc.closeAll();
                jdbc = null;
            }
        }
    }

    private static String createAlphanumericSecret() {
        return RandomStringUtils.randomAlphanumeric((int)128);
    }
}

