/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.login;

import de.narimo.commons.dto.User;
import de.narimo.commons.json.JsonConverter;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.geocore.ws.auth.JWTFactory;
import de.narimo.geocore.ws.repository.UserRepository;
import javax.naming.AuthenticationException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public class LoginProvider {
    public static Response createLoginResponse(ServletContext ctx, HttpServletRequest request, String loggedInUser, String workspacePermissionType) {
        Response.ResponseBuilder rb;
        try {
            rb = Response.ok();
            Cookie c = ((HTTPAuthorizationFactory)request.getAttribute("authFactory")).getSessionCookies()[0];
            if (c == null) {
                throw new AuthenticationException("No valid login credentials.");
            }
            if (!c.getName().equals("GSESSIONID")) {
                throw new IllegalStateException("No valid authentication details provided.");
            }
            String sessionToken = c.getValue();
            System.out.println("Created session for user " + loggedInUser + " with token: " + sessionToken);
            if (ctx.getInitParameter("JWT_PRIVATE_SERVER_SECRET") == null) {
                throw new IllegalStateException("Define jwt server secret!");
            }
            JWTFactory jwtFactory = new JWTFactory(ctx.getInitParameter("JWT_PRIVATE_SERVER_SECRET"), ctx.getInitParameter("JWT_ISSUER"));
            jwtFactory.setAccessToken(sessionToken);
            String jwtToken = jwtFactory.createToken(0);
            rb.header("x-narimosessid", (Object)jwtToken);
            User user = UserRepository.getUser(loggedInUser).get();
            if (workspacePermissionType != null) {
                user.setType(workspacePermissionType);
            }
            rb.entity((Object)JsonConverter.toJson((Object)user));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Login: Successful, but no session created as no session token has been provided.");
            rb = Response.status((int)403);
        }
        return rb.build();
    }

    public static Response createLogoutResponse(HttpServletRequest request, String serverApplication) {
        request.setAttribute("stateless", (Object)true);
        Response.ResponseBuilder rb = Response.ok();
        NewCookie c = new NewCookie("narimosessid", "", "/" + serverApplication + "/", null, null, 0, true);
        rb.cookie(new NewCookie[]{c});
        return rb.build();
    }
}

