/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import de.narimo.geocore.ws.auth.tools.AuthenticationTools;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.UriInfo;

public class GeorepoBasicAuthentication {
    public static void authenticateBasic(ServletContext ctx, ContainerRequestContext requestContext, UriInfo uriinfo, UserCredentials credentials) throws Exception {
        String georepoUrl;
        boolean createSession = false;
        try {
            String sessionParam = (String)((List)uriinfo.getQueryParameters().get((Object)"sess")).get(0);
            createSession = Boolean.parseBoolean(sessionParam);
        }
        catch (Exception sessionParam) {
            // empty catch block
        }
        System.out.println("Create permanent session? " + createSession);
        String sessionId = null;
        sessionId = AuthenticationTools.createSession(credentials.getUsername(), credentials.getPassword());
        if (!createSession) {
            requestContext.setProperty("stateless", (Object)true);
        }
        if ((georepoUrl = ctx.getInitParameter("georepoUrlInternal")) == null) {
            throw new IllegalStateException("Context parameter georepoUrlInternal is not defined.");
        }
        HTTPAuthorizationFactory authFactory = new HTTPAuthorizationFactory();
        Cookie sessionCookie = new Cookie("GSESSIONID", sessionId, new URL(georepoUrl).getPath(), "localhost");
        if (sessionCookie != null) {
            authFactory.setSessionCookies(new Cookie[]{sessionCookie});
        }
        if (credentials != null) {
            authFactory.setCredentials(credentials);
        }
        requestContext.setProperty("authFactory", (Object)authFactory);
    }
}

