/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.geocore.ws.auth;

import de.narimo.commons.UserCredentials;
import de.narimo.commons.jdbc.JDBCConnectionJNDI;
import de.narimo.commons.ws.http.auth.HTTPAuthorizationFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ws.rs.container.ContainerRequestContext;

public class ApiKeyAuth {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserCredentials authenticateApiKey(ContainerRequestContext requestContext, String apiKey) throws Exception {
        System.out.println("Checking provided api key " + apiKey + ".");
        if (apiKey == null) {
            return null;
        }
        JDBCConnectionJNDI jdbcAuth = null;
        ResultSet rs = null;
        UserCredentials credentials = null;
        try {
            jdbcAuth = new JDBCConnectionJNDI("jdbc/georepoAuthDatasource");
            String sql = "SELECT u.username FROM public.apikeys a, public.users u WHERE a.userid = u.id AND  a.apikey=? AND a.enabled=TRUE AND u.enabled=TRUE AND (a.expires=timezone('utc'::text, 'epoch') OR a.expires>timezone('utc'::text, now())) LIMIT 1";
            PreparedStatement ps = jdbcAuth.prepareStatement(sql);
            ps.setString(1, apiKey);
            rs = ps.executeQuery();
            if (!rs.next()) {
                UserCredentials userCredentials = null;
                return userCredentials;
            }
            credentials = new UserCredentials();
            credentials.setUserCredentials(rs.getString("username"), "");
            HTTPAuthorizationFactory authFactory = new HTTPAuthorizationFactory();
            authFactory.setCredentials(credentials);
            requestContext.setProperty("authFactory", (Object)authFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Look up for api key " + apiKey + " failed. Api key not valid.");
        }
        finally {
            if (jdbcAuth != null) {
                jdbcAuth.closeAll();
            }
        }
        return credentials;
    }
}

