/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.csv;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import de.narimo.commons.dto.csv.bna.Powerplant;
import de.narimo.commons.dto.csv.bna.PowerplantAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class CSVTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void concatCSVFiles(List<File> csvFiles, File outputCSVFile, char delimiter) {
        CsvReader r = null;
        CsvWriter w = null;
        try {
            w = new CsvWriter((Writer)new FileWriter(outputCSVFile, false), delimiter);
            Object[] header = null;
            for (File csvFile : csvFiles) {
                r = new CsvReader(csvFile.getAbsolutePath(), delimiter, StandardCharsets.UTF_8);
                r.readHeaders();
                Object[] headers = r.getHeaders();
                if (header == null) {
                    header = headers;
                    for (int i = 0; i < headers.length; ++i) {
                        w.write((String)headers[i]);
                    }
                    w.endRecord();
                    w.flush();
                } else if (!Arrays.equals(headers, header)) {
                    throw new RuntimeException("Header of file " + csvFile + " does not equal expected header signature.");
                }
                while (r.readRecord()) {
                    String[] values = r.getValues();
                    if (CSVTools.recordIsEmpty(values)) continue;
                    for (int i = 0; i < values.length; ++i) {
                        w.write(values[i]);
                    }
                    w.endRecord();
                    w.flush();
                }
                r.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (w != null) {
                w.close();
            }
            if (r != null) {
                r.close();
            }
        }
    }

    public static File csv2ObjectList(File csvgeom, File csvatt, Charset charset, char separator) throws Exception {
        CsvMapper mapper = new CsvMapper();
        CsvSchema geomSchema = CsvSchema.emptySchema().withHeader().withColumnSeparator(separator);
        MappingIterator geom = mapper.readerFor(Powerplant.class).with((FormatSchema)geomSchema).readValues(csvgeom);
        FileInputStream fis = new FileInputStream(csvatt);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, charset);
        MappingIterator at = mapper.readerFor(PowerplantAttribute.class).with((FormatSchema)geomSchema).readValues((Reader)isr);
        CsvSchema outSchema = mapper.schemaFor(Powerplant.class).withColumnSeparator(separator);
        File csvOutFile = new File(csvatt.getAbsolutePath() + "-out.csv");
        FileOutputStream fos = new FileOutputStream(csvOutFile);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, charset);
        List plantsGeoms = geom.readAll();
        List plantsAtts = at.readAll();
        ArrayList<Powerplant> plantsMerged = new ArrayList<Powerplant>();
        block0: for (Powerplant g : plantsGeoms) {
            if (g.getKraftwerksnummer() == null) continue;
            for (PowerplantAttribute a : plantsAtts) {
                if (!a.getKraftwerksnummer().equals(g.getKraftwerksnummer())) continue;
                Powerplant p = new Powerplant();
                p = g;
                p.setAdresse(a.getAdresse());
                p.setBlockname(a.getBlockname());
                p.setLeistungMW(a.getLeistungMW());
                p.setBundesland(a.getBundesland());
                p.setEEGAnlage(a.getEEGAnlage());
                p.setEnergietr\u00e4ger(a.getEnergietr\u00e4ger());
                p.setErzeugungsbeginn(a.getErzeugungsbeginn());
                p.setHauptbrennstoff(a.getHauptbrennstoff());
                p.setHauptbrennstoffe(a.getHauptbrennstoffe());
                p.setKraftwerksname(a.getKraftwerksname());
                p.setNetzebeneKV(a.getNetzebeneKV());
                p.setOrt(a.getOrt());
                p.setPLZ(a.getPLZ());
                p.setStatus(a.getStatus());
                p.setStromnetzBetreiber(a.getStromnetzBetreiber());
                p.setUnternehmen(a.getUnternehmen());
                p.setVerknuepfungspunkt(a.getVerknuepfungspunkt());
                p.setWaermeauskopplung(a.getWaermeauskopplung());
                p.setZusatzbrennstoffe(a.getZusatzbrennstoffe());
                plantsMerged.add(p);
                continue block0;
            }
        }
        boolean cnt = true;
        mapper.writer((FormatSchema)outSchema).writeValue((Writer)osw, plantsMerged);
        return csvOutFile;
    }

    public static boolean recordIsEmpty(String[] record) {
        for (int i = 0; i < record.length; ++i) {
            if (record[i].trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File addHeaderToFile(List<String> headerL, File csvFile, char delimiter, Charset charset) {
        CsvReader r = null;
        CsvWriter w = null;
        File csvOutFile = new File(csvFile.getAbsolutePath() + "-out.csv");
        try {
            w = new CsvWriter((Writer)new FileWriter(csvOutFile, false), delimiter);
            r = new CsvReader(csvFile.getAbsolutePath(), delimiter, charset);
            for (String head : headerL) {
                w.write(head);
            }
            w.endRecord();
            while (r.readRecord()) {
                String[] values = r.getValues();
                if (CSVTools.recordIsEmpty(values)) continue;
                for (int i = 0; i < values.length; ++i) {
                    w.write(values[i]);
                }
                w.endRecord();
                w.flush();
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (w != null) {
                w.close();
            }
            if (r != null) {
                r.close();
            }
        }
        return csvOutFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeToCSVFile(HashSet<HashSet<String>> set, File csvOutFile, char delimiter, Charset charset) {
        try (CsvWriter w = null;){
            w = new CsvWriter((Writer)new FileWriter(csvOutFile, false), delimiter);
            for (HashSet<String> sub : set) {
                for (String s : sub) {
                    s = s.replace("\n", " ");
                    s = s.replace("\r", " ");
                    w.write(s);
                }
                w.endRecord();
                w.flush();
            }
        }
        return csvOutFile;
    }

    public static void main(String[] args) throws Exception {
        char csvSeparator = ';';
        Charset charset = StandardCharsets.ISO_8859_1;
        File csvFile = new File("C:/Users/admin/Desktop/Kraftwerksliste_CSV_2017-11 (2).csv");
        ArrayList<String> headerL = new ArrayList<String>();
        headerL.add("Kraftwerksnummer Bundesnetzagentur");
        headerL.add("Unternehmen");
        headerL.add("Kraftwerksname");
        headerL.add("PLZ");
        headerL.add("Ort");
        headerL.add("Stra\u00dfe und Hausnummer");
        headerL.add("Bundesland");
        headerL.add("Blockname");
        headerL.add("Aufnahme der kommerziellen Stromerzeugung (Jahr)");
        headerL.add("Kraftwerksstatus");
        headerL.add("Energietr\u00e4ger");
        headerL.add("Spezifizierung Hauptbrennstoff");
        headerL.add("Spezifizierung Zusatzbrennstoffe");
        headerL.add("Hauptenergietr\u00e4ger");
        headerL.add("Verg\u00fctungsf\u00e4hig nach EEG");
        headerL.add("W\u00e4rmeauskopplung");
        headerL.add("Netto-Nennleistung in MW");
        headerL.add("Verkn\u00fcpfungspunkt Stromnetz");
        headerL.add("Netzebene in kV");
        headerL.add("Name Stromnetzbetreiber");
        File csvModifiedFile = CSVTools.addHeaderToFile(headerL, csvFile, csvSeparator, charset);
        File readGeomFile = new File("C:/Users/admin/Desktop/BNA_power_plant_geometries.csv");
        File readAttFile = csvModifiedFile;
        File outfile = CSVTools.csv2ObjectList(readGeomFile, readAttFile, charset, csvSeparator);
        CSVTools.addHeaderToFile(headerL, outfile, csvSeparator, charset);
    }
}

