/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class JDBCConnection {
    String userName;
    String password;
    String dbms;
    String serverName;
    String dbName;
    String portNumber;
    Connection connection;

    public JDBCConnection(String dbType, String dbName, String userName, String userPass) throws SQLException {
        this(dbType, dbName, userName, userPass, "5432");
    }

    public JDBCConnection(String dbType, String dbName, String userName, String userPass, String port) throws SQLException {
        this.userName = userName;
        this.password = userPass;
        this.dbms = dbType;
        this.serverName = "localhost";
        this.portNumber = port;
        this.dbName = dbName;
        this.getConnection();
    }

    public void getConnection() throws SQLException {
        Connection conn = null;
        Properties connectionProps = new Properties();
        connectionProps.put("user", this.userName);
        connectionProps.put("password", this.password);
        String connString = "";
        if (this.dbms.equals("mysql")) {
            connString = "jdbc:" + this.dbms + "://" + this.serverName + ":" + this.portNumber + "/";
        } else if (this.dbms.equals("postgresql")) {
            connString = "jdbc:" + this.dbms + "://" + this.serverName + ":" + this.portNumber + "/" + this.dbName;
        }
        System.out.println("Connecting to " + connString);
        try {
            conn = DriverManager.getConnection(connString, connectionProps);
        }
        catch (SQLException se) {
            se.printStackTrace();
            try {
                Class.forName("org.postgresql.Driver");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Connected to database " + this.dbName);
        this.connection = conn;
    }

    public ResultSet executeQuery(String sql) throws Exception {
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(sql);
    }

    public boolean execute(String sql) throws Exception {
        Statement stmt = this.connection.createStatement();
        return stmt.execute(sql);
    }

    public PreparedStatement prepareStatement(String sql) throws Exception {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        return ps;
    }

    public ResultSet executePreparedQuery(PreparedStatement ps) throws Exception {
        return ps.executeQuery();
    }

    public int executePreparedUpdate(PreparedStatement ps) throws Exception {
        return ps.executeUpdate();
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public static void main(String[] args) throws SQLException {
    }
}

