/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JDBCConnectionJNDI {
    private Connection connection;
    private List<Statement> statements = new ArrayList<Statement>();
    private List<ResultSet> resultSets = new ArrayList<ResultSet>();
    private List<PreparedStatement> preparedStatements = new ArrayList<PreparedStatement>();
    private int connectionId;
    private boolean autoCommitDefault;

    public JDBCConnectionJNDI(String JNDIResource) {
        try {
            DataSource ds = (DataSource)new InitialContext().lookup("java:/comp/env/" + JNDIResource);
            if (ds == null) {
                throw new Exception("Data source not found!");
            }
            this.connection = ds.getConnection();
            this.connectionId = (int)(Math.random() * 1000.0);
            System.out.println("Connection with id " + this.connectionId + " was opened.");
            this.autoCommitDefault = this.connection.getAutoCommit();
        }
        catch (Exception e) {
            throw new RuntimeException("Error when creating datasource: " + e);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        Statement stmt = this.connection.createStatement();
        this.statements.add(stmt);
        ResultSet rs = stmt.executeQuery(sql);
        this.resultSets.add(rs);
        return rs;
    }

    public boolean execute(String sql) throws SQLException {
        Statement stmt = this.connection.createStatement();
        this.statements.add(stmt);
        return stmt.execute(sql);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        this.preparedStatements.add(ps);
        return ps;
    }

    public ResultSet executePreparedQuery(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.executeQuery();
        this.resultSets.add(rs);
        return rs;
    }

    public int executePreparedUpdate(PreparedStatement ps) throws SQLException {
        int res = ps.executeUpdate();
        return res;
    }

    @Deprecated
    public void close() throws SQLException {
        this.closeAll();
    }

    public void closeAll() {
        try {
            for (ResultSet rs : this.resultSets) {
                if (rs != null) {
                    rs.close();
                }
                rs = null;
            }
            for (Statement stmt : this.statements) {
                if (stmt != null) {
                    stmt.close();
                }
                stmt = null;
            }
            for (PreparedStatement ps : this.preparedStatements) {
                if (ps != null) {
                    ps.close();
                }
                Object var2_3 = null;
            }
            if (this.connection != null) {
                this.connection.setAutoCommit(this.autoCommitDefault);
                this.connection.close();
                this.connection = null;
                System.out.println("Connection with id " + this.connectionId + " was closed.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public static void main(String[] args) throws SQLException {
    }
}

