/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class JsonConverter {
    public static <T> T fromJson(String json, Class<T> type) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (json == null) {
            return null;
        }
        if (json.startsWith("[")) {
            json = json.substring(1);
        }
        if (json.endsWith("]")) {
            json = json.substring(0, json.length() - 1);
        }
        return (T)mapper.readValue(json, type);
    }

    public static <T> T fromJson(File jsonFile, Class<T> type) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return (T)mapper.readValue(jsonFile, type);
    }

    public static <T> List<T> fromJsonToList(String json, Class<T> type) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (json == null) {
            return null;
        }
        CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, type);
        return (List)mapper.readValue(json, (JavaType)collectionType);
    }

    public static <T> Set<T> fromJsonToSet(String json, Class<T> type) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (json == null) {
            return null;
        }
        CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(LinkedHashSet.class, type);
        return (Set)mapper.readValue(json, (JavaType)collectionType);
    }

    public static String toJson(Object pojo) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(pojo);
    }

    public static void main(String[] args) throws IOException {
    }
}

