/*
 * Decompiled with CFR 0.152.
 */
package de.narimo.commons.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class XML2CSV {
    public static void main(String[] args) throws Exception {
        File stylesheet = new File("C:\\Users\\admin\\Documents\\workspace\\git\\commons\\src\\main\\java\\de\\narimo\\commons\\imports\\qb4.xsl");
        File outCSVFile = new File("G:\\narimo\\Geschaeft\\Datenprodukte\\Krankenhaeuser\\qb-processed\\qb2015_singles.csv");
        List<Object> xmlFiles = new ArrayList();
        String xmlDirectory = "G:\\narimo\\Geschaeft\\Datenprodukte\\Krankenhaeuser\\qb-raw";
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        String start = sdf.format(new Date());
        System.out.println("Starting operation at " + start + ".");
        System.out.println("Searching files to process in folder " + xmlDirectory + "...");
        xmlFiles = Arrays.asList(new File(xmlDirectory).listFiles());
        System.out.println("Found " + xmlFiles.size() + " files to process.");
        XML2CSV.transformToSingleFile(xmlFiles, stylesheet, outCSVFile);
        String fin = sdf.format(new Date());
        System.out.println("Started operation at " + start + ".");
        System.out.println("Finished operation at " + fin + ".");
    }

    public static void transform(File xmlFile, File xslFile, File outputFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlFile);
        StreamSource stylesource = new StreamSource(xslFile);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(stylesource);
        DOMSource source = new DOMSource(document);
        StreamResult outputTarget = new StreamResult(outputFile);
        transformer.transform(source, outputTarget);
    }

    public static void transformToSingleFile(List<File> xmlFiles, File xslFile, File outputFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        System.out.println("Writing to: " + outputFile.getAbsolutePath());
        FileWriter fw = new FileWriter(outputFile.getAbsolutePath(), false);
        try {
            int cnt = 1;
            for (File xmlFile : xmlFiles) {
                if (!xmlFile.isFile() || !xmlFile.getName().endsWith(".xml")) continue;
                File intermediateFile = new File(cnt + ".csv");
                Document document = builder.parse(xmlFile);
                StreamSource stylesource = new StreamSource(xslFile);
                Transformer transformer = TransformerFactory.newInstance().newTransformer(stylesource);
                DOMSource source = new DOMSource(document);
                StreamResult outputTarget = new StreamResult(intermediateFile);
                transformer.transform(source, outputTarget);
                List<String> lines = Files.readAllLines(Paths.get(intermediateFile.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8);
                if (cnt == 1) {
                    for (String line : lines) {
                        fw.append(line);
                        fw.append("\n");
                    }
                } else {
                    fw.append(lines.get(lines.size() - 1));
                    fw.append("\n");
                }
                intermediateFile.delete();
                ++cnt;
                fw.flush();
                System.out.println("Read dataset " + xmlFile + ".");
            }
            System.out.println("Finished XML2CSV conversion. Converted " + (cnt - 1) + " out of " + xmlFiles.size() + " files.");
        }
        catch (IOException e) {
            fw.close();
        }
    }
}

